DROP FUNCTION if exists public.p_est_prod_desc_campanha(integer, integer, integer, integer, integer, integer);

DROP TYPE IF EXISTS public.rs_prod_campanha;

CREATE TYPE public.rs_prod_campanha AS (
	cd_prod int4,
	cd_campanha_adic int4,
	ds_campanha_adic varchar(255),
	qt_it int4,
	vlr_desconto float8,
	vlr_item float8,
	vlr_venda float8,
	agregacao int4,
	qt_utilizado int4,
	brinde  int4
	);


CREATE OR REPLACE FUNCTION public.p_est_prod_desc_campanha (integer, integer, integer, integer, integer DEFAULT 0, integer DEFAULT 0)
 RETURNS SETOF rs_prod_campanha
 LANGUAGE plpgsql
AS $function$



	DECLARE
	---------------------------------------------------------
	----DECLARA AS VARIVEIS QUE ESTO NO CABECALHO DA FUNCAO
	---------------------------------------------------------
	in_cd_emp              ALIAS FOR $1;
	in_cd_filial           ALIAS FOR $2;
	in_nr_cx               ALIAS FOR $3;
	in_cd_vd     	       ALIAS FOR $4;
    in_tp_pdv    	       ALIAS FOR $5;
	in_usa_desconto_propz_ident ALIAS FOR $6;		
	---------------------------------------------------------
	---FIM
	---------------------------------------------------------
        --declaracao variaveis                                setando valores nas variaveis
	var_vlr_desconto double precision = 0;
	var_count integer = 0;

	var_vlr_descont_receb double precision = 0;
	rec   record;
	rec_familia record;
	rProdBrinde record;

	rRetorno rs_prod_campanha;

	rCampanhas  record;
	vMenorDireito integer = 0;

	retTemp  record;

	var_total_item_desconto integer;
	var_qt_it_posivel_brinde integer = 0;
	var_codigo_campanha integer = 0;

	var_qtde_prod_campanha_familia integer = 0;

	var_prod integer;

	var_iterator integer = 0;
	var_test integer = 0;


	
BEGIN

	IF ((SELECT tipo_pbm from pdv_vd where cd_emp = in_cd_emp and cd_filial = in_cd_filial and cd_cx = in_nr_cx and cd_vd = in_cd_vd) > 0)
	THEN
		RETURN;
	END IF;

	--- criando tabelas temporarias
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA TEMPORARIA DE RETORNO
	-------------------------------------------------------------------------------------------------------------------------------

	BEGIN
		CREATE TEMPORARY TABLE RetornoTemp
		(cd_prod integer,
			cd_campanha_adic integer,
			ds_campanha_adic character varying(255),
			vlr_desconto double precision,
			qt_it integer,
			vlr_item double precision,
			vlr_venda double precision,
			brinde smallint
			);
		
		
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE RetornoTemp; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.

	END;

	BEGIN
		CREATE TEMPORARY TABLE RsCampanha
		(   -- valores de consulta unica
		    cd_emp integer,
			cd_campanha_adic integer,
			tp_campanha integer

		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE RsCampanha; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.

	END;

	BEGIN
		CREATE TEMPORARY TABLE RsCampanhaProduto
		(   -- valores de consulta unica
		    cd_emp integer,
			cd_campanha_adic integer,
			cd_prod integer,
			qtde_prod integer,
			saldo integer,
			Utilizado integer,
			desconto double precision,
			vlr_item double precision,
			vlr_venda double precision
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE RsCampanhaProduto; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.

	END;

	BEGIN
		CREATE TEMPORARY TABLE RsCampanhaFamilia
		(   -- valores de consulta unica
		    cd_emp INTEGER,
			cd_campanha_adic INTEGER,
			cd_arv_merc_familia integer,
			qtde_prod integer,
			saldo integer

		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE RsCampanhaFamilia; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.

	END;

	BEGIN
		CREATE TEMPORARY TABLE RsCampanhaProdutoFamilia
		(   -- valores de consulta unica
		    cd_emp integer,
			cd_campanha_adic integer,
			cd_arv_merc_familia integer,
			cd_prod integer,
			qtde_prod integer

		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE RsCampanhaProdutoFamilia; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.

	END;

	BEGIN
		CREATE TEMPORARY TABLE RsCampanhaPossivelAquisicao
		(   -- valores de consulta unica
		    tp_campanha integer,
		    cd_emp integer,
			cd_prod integer,
			cd_campanha_adic integer,
			qt_it_posivel_brinde integer,
			deduzir integer,
			desconto double precision,
			vlr_item double precision,
			vlr_venda double precision

		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE RsCampanhaPossivelAquisicao; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.

	END;

IF in_tp_pdv = 0 THEN

-------------------------------------------------------------------
-- INSERINDO PROD CAMPANHA

	INSERT INTO RsCampanhaProduto
	SELECT a.cd_emp,
		   a.cd_campanha_adic,
		   a.cd_prod,
		   a.qtde_prod,
            sum(coalesce(c.qt_it,0)) as saldo
	FROM   pdv_campanha_adicionais_est_prod_campanha a
		   INNER JOIN (SELECT a.*
					     FROM pdv_campanha_adicionais  a 
					   		  JOIN pdv_campanha_adicionais_prc_filial fil ON a.cd_campanha_adic = fil.cd_campanha_adic
							                                             AND a.cd_emp = fil.cd_emp 							 
					    WHERE fil.cd_filial = in_cd_filial 
					      AND DATE(a.dt_inicio)  <= CURRENT_DATE
					  	  AND DATE(a.dt_valid)   >= CURRENT_DATE
						AND (
							((in_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1)) ) OR 
							((in_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz not in (1,2)))
							)							  
					    ) b  ON a.cd_emp	       = b.cd_emp
					    AND a.cd_campanha_adic = b.cd_campanha_adic
					
							
		   LEFT JOIN (SELECT a.cd_emp,
							 a.cd_prod,
							 Sum(a.qt_it) qt_it
					    FROM pdv_cupom_it a
					   WHERE a.cd_emp    = in_cd_emp 
					     and a.cd_filial = in_cd_filial 
					     and a.cd_cx     = in_nr_cx 
					     and a.cd_ctr    = in_cd_vd 
					     and flag_direto_caixa = 1
					     AND a.sts_prod = 1
					   GROUP  BY a.cd_prod, a.cd_emp) c  ON a.cd_emp = c.cd_emp
											            AND a.cd_prod = c.cd_prod
	GROUP  BY a.cd_emp,a.cd_campanha_adic,a.cd_prod,a.qtde_prod;


	insert into RsCampanha
	select cd_emp, cd_campanha_adic, 0 from RsCampanhaProduto group by cd_emp, cd_campanha_adic;
	-------------------------------------------------------------------------
	-- INSERINDO FAMILIA CAMPANHA
	INSERT INTO RsCampanhaFamilia
	select
		   a.cd_emp,
		   a.cd_campanha_adic,
		   a.cd_arv_merc_familia,
		   a.qtde_prod,
		   sum(coalesce(c.qt_it,0)) as saldo
	from
	  pdv_campanha_adicionais_est_arv_merc_familia_campanha a
	  INNER JOIN (SELECT a.*
					FROM pdv_campanha_adicionais a
					     JOIN pdv_campanha_adicionais_prc_filial fil ON a.cd_campanha_adic = fil.cd_campanha_adic
							                                        AND a.cd_emp = fil.cd_emp 							 
				   WHERE fil.cd_filial = in_cd_filial
					 AND DATE(a.dt_inicio) <= CURRENT_DATE
					 AND DATE(a.dt_valid ) >= CURRENT_DATE
					 AND (
						((in_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1)) ) OR 
						((in_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz not in (1,2)))
					 )					 
				     ) b  ON a.cd_emp           = b.cd_emp
					 AND a.cd_campanha_adic = b.cd_campanha_adic

			LEFT JOIN (SELECT a.cd_emp,
							  b.cd_arv_merc_familia ,
							  Sum(a.qt_it) qt_it
					     FROM pdv_cupom_it a 
					          inner join est_prod_est_arv_mercadologica b  on a.cd_emp = b.cd_emp 
								           							      and a.cd_prod = b.cd_prod
					    WHERE a.cd_emp    = in_cd_emp 
						  and a.cd_filial = in_cd_filial 
						  and a.cd_cx     = in_nr_cx 
						  and a.cd_ctr    = in_cd_vd 
						  and flag_direto_caixa = 1
						  AND sts_prod     = 1
					    GROUP BY a.cd_emp,
							     b.cd_arv_merc_familia) c ON a.cd_emp = c.cd_emp
													     AND a.cd_arv_merc_familia = c.cd_arv_merc_familia
	group by
	a.cd_emp,
		   a.cd_campanha_adic,
		   a.cd_arv_merc_familia,
		   a.qtde_prod ;


	insert into RsCampanha
	select cd_emp, cd_campanha_adic, 1 from RsCampanhaFamilia  group by cd_emp, cd_campanha_adic;
    
	   --select RsCampanha

	INSERT INTO RsCampanhaProdutoFamilia
	select
		   a.cd_emp,
		   a.cd_campanha_adic,
		   a.cd_arv_merc_familia,
		   c.cd_prod,
		   c.qt_it
	from
	  pdv_campanha_adicionais_est_arv_merc_familia_campanha a
	  INNER JOIN (SELECT *
				    FROM pdv_campanha_adicionais
				   WHERE DATE(dt_inicio) <= CURRENT_DATE 
					 AND DATE(dt_valid)  >= CURRENT_DATE
					 AND (
							((in_usa_desconto_propz_ident = 1) AND (flag_tp_desconto_propz in(0,1)) ) OR 
							((in_usa_desconto_propz_ident = 0) AND (flag_tp_desconto_propz not in (1,2)))
						 )					 
					) b ON a.cd_emp = b.cd_emp
					AND a.cd_campanha_adic = b.cd_campanha_adic

			inner JOIN (SELECT a.cd_emp, a.cd_prod,
							   b.cd_arv_merc_familia ,
							   sum(a.qt_it) qt_it
					      FROM pdv_cupom_it a 
						       inner join est_prod_est_arv_mercadologica b  on a.cd_emp = b.cd_emp 
																		   and a.cd_prod = b.cd_prod
					     WHERE a.cd_emp = in_cd_emp 
						   and a.cd_filial = in_cd_filial 
						   and a.cd_cx = in_nr_cx 
						   and a.cd_ctr = in_cd_vd 
						   and flag_direto_caixa = 1
                           AND sts_prod = 1
					     group by a.cd_emp, 
						          a.cd_prod,
							      b.cd_arv_merc_familia ) c ON a.cd_emp = c.cd_emp
														   AND a.cd_arv_merc_familia = c.cd_arv_merc_familia;


	INSERT INTO RsCampanhaPossivelAquisicao
	SELECT d.tp_campanha,
	       a.cd_emp,
		   a.cd_prod,
		   b.cd_campanha_adic,
		   cast(sum(a.qt_it) as integer) qt_it_posivel_brinde ,
	       b.qt_venda, 
		   round(a.vl_unit * (1-(a.tx_desc/100)), 2) - b.vlr_venda as desconto, 
		   round(a.vl_unit * (1-(a.tx_desc/100)), 2),
		   b.vlr_venda
	  FROM pdv_cupom_it a 
	       inner join pdv_campanha_adicionais_est_prod b on a.cd_emp = b.cd_emp 
														and a.cd_prod=b.cd_prod 
		   inner join pdv_campanha_adicionais c on b.cd_emp = c.cd_emp 
										       and b.cd_campanha_adic = c.cd_campanha_adic 
		   INNER JOIN RsCampanha d on c.cd_emp = d.cd_emp 
								  and c.cd_campanha_adic = d.cd_campanha_adic 
	  WHERE a.cd_emp    = in_cd_emp 
	    and a.cd_filial = in_cd_filial 
		and a.cd_cx     = in_nr_cx 
		and a.cd_ctr    = in_cd_vd 
		and flag_direto_caixa = 1
		AND sts_prod = 1 
		and DATE(dt_inicio ) <= CURRENT_DATE
		AND DATE(dt_valid  ) >= CURRENT_DATE
		AND (
			((in_usa_desconto_propz_ident = 1) AND (c.flag_tp_desconto_propz in(0,1)) ) OR 
			((in_usa_desconto_propz_ident = 0) AND (c.flag_tp_desconto_propz not in (1,2)))
		)		
	  GROUP BY a.cd_prod,
	           a.cd_emp,
			   b.cd_campanha_adic, 
			   b.vlr_venda, 
			   a.vl_unit, 
			   b.qt_venda,
			   a.tx_desc,
			   d.tp_campanha
      ORDER BY a.cd_prod asc;
 
     delete 
	   from RsCampanhaPossivelAquisicao 
	  where cd_campanha_adic in ( select min(cd_campanha_adic) 
									from RsCampanhaPossivelAquisicao 
								   where cd_prod in ( select cd_prod 
														from RsCampanhaPossivelAquisicao 
													   group by cd_prod having count(1) > 1
	   )
	);
	
ELSIF ( IN_TP_PDV = 3 ) THEN

-------------------------------------------------------------------
	-- INSERINDO PROD CAMPANHA
	
	INSERT INTO RsCampanhaProduto
	SELECT a.cd_emp,
		   a.cd_campanha_adic,
		   a.cd_prod,
		   a.qtde_prod,
           sum(coalesce(c.qt_it,0)) as saldo,
           0 as Utilizado,
	       Avg(c.vlr_item) - Avg( c.vlr_item_liq) as  desconto ,
		   Avg(c.vlr_item) as vlr_item,
		   Avg(c.vlr_item_liq)	as vlr_venda 
	FROM   pdv_campanha_adicionais_est_prod_campanha a
		  INNER JOIN (SELECT a.*
					    FROM pdv_campanha_adicionais a
					         join pdv_campanha_adicionais_prc_filial fil on a.cd_campanha_adic = fil.cd_campanha_adic
							                                            and a.cd_emp = fil.cd_emp 							 
					   WHERE fil.cd_filial = in_cd_filial 
					     and DATE(a.dt_inicio)  <= CURRENT_DATE
						 AND DATE(a.dt_valid )  >= CURRENT_DATE
						AND	(
							((in_usa_desconto_propz_ident = 1) AND (A.flag_tp_desconto_propz in(0,1)) ) OR 
							((in_usa_desconto_propz_ident = 0) AND (A.flag_tp_desconto_propz not in (1,2)))
							)		 
						) b ON a.cd_emp = b.cd_emp
						AND a.cd_campanha_adic = b.cd_campanha_adic
		   LEFT JOIN (SELECT a.cd_emp,
							 a.cd_prod,
							 Sum(a.qt_it) qt_it,
							 AVG(a.vlr_item) vlr_item,
							 Avg(a.vlr_item_liq) vlr_item_liq 
					  FROM   EST_PROD_DESCONTO_TEMP a
					  WHERE a.cd_emp = in_cd_emp 
						and a.cd_filial = in_cd_filial 
						and a.cd_ctr_vd  = in_cd_vd   
					  GROUP  BY a.cd_prod, a.cd_emp) c ON a.cd_emp = c.cd_emp
													  AND a.cd_prod = c.cd_prod
	GROUP  BY a.cd_emp,a.cd_campanha_adic,a.cd_prod,a.qtde_prod;


	insert into RsCampanha
	select cd_emp, cd_campanha_adic, 0 from RsCampanhaProduto group by cd_emp, cd_campanha_adic;
	
	-------------------------------------------------------------------------
	
	-- INSERINDO FAMILIA CAMPANHA
	INSERT INTO RsCampanhaFamilia
	select
		   a.cd_emp,
		   a.cd_campanha_adic,  
		   a.cd_arv_merc_familia,
		   a.qtde_prod,
		   sum(coalesce(c.qt_it,0)) as saldo
	from
	  pdv_campanha_adicionais_est_arv_merc_familia_campanha a
	  INNER JOIN (SELECT a.*
					FROM pdv_campanha_adicionais a
					     join pdv_campanha_adicionais_prc_filial fil on a.cd_campanha_adic = fil.cd_campanha_adic
							                                        and a.cd_emp = fil.cd_emp 							 
			       WHERE fil.cd_filial = in_cd_filial 
						and DATE(a.dt_inicio )<= CURRENT_DATE
						AND DATE(a.dt_valid  )>= CURRENT_DATE
						AND	(
							((in_usa_desconto_propz_ident = 1) AND (A.flag_tp_desconto_propz in(0,1)) ) OR 
							((in_usa_desconto_propz_ident = 0) AND (A.flag_tp_desconto_propz not in (1,2)))
							)
					 					  
						) b ON a.cd_emp = b.cd_emp
						AND a.cd_campanha_adic = b.cd_campanha_adic
					
           LEFT JOIN (SELECT a.cd_emp,
						     b.cd_arv_merc_familia ,
							 Sum(a.qt_it) qt_it
					    FROM EST_PROD_DESCONTO_TEMP a
        					 inner join est_prod_est_arv_mercadologica b  on a.cd_emp = b.cd_emp 
																		 and a.cd_prod = b.cd_prod
 					   WHERE a.cd_emp    = in_cd_emp 
					     and a.cd_filial = in_cd_filial 
						 and a.cd_ctr_vd     = in_cd_vd  
					   GROUP  BY a.cd_emp,
							     b.cd_arv_merc_familia) c ON a.cd_emp = c.cd_emp
														 AND a.cd_arv_merc_familia = c.cd_arv_merc_familia
	group by
		a.cd_emp,
		a.cd_campanha_adic,
		a.cd_arv_merc_familia,
		a.qtde_prod ;

 
	insert into RsCampanha
	select cd_emp, cd_campanha_adic, 1 from RsCampanhaFamilia  group by cd_emp, cd_campanha_adic;


	INSERT INTO RsCampanhaProdutoFamilia
	select
		   a.cd_emp,
		   a.cd_campanha_adic,
		   a.cd_arv_merc_familia,
		   c.cd_prod,
		   COALESCE (c.qt_it,0)
	from
	  pdv_campanha_adicionais_est_arv_merc_familia_campanha a
	  INNER JOIN (SELECT a.*
					FROM pdv_campanha_adicionais a
					     join pdv_campanha_adicionais_prc_filial fil on a.cd_campanha_adic = fil.cd_campanha_adic
							                                        and a.cd_emp = fil.cd_emp 							 
				   WHERE fil.cd_filial = in_cd_filial 
					 and DATE(a.dt_inicio)   <= CURRENT_DATE
					 AND DATE(a.dt_valid )   >= CURRENT_DATE
		AND	(
			((in_usa_desconto_propz_ident = 1) AND (A.flag_tp_desconto_propz in(0,1)) ) OR 
			((in_usa_desconto_propz_ident = 0) AND (A.flag_tp_desconto_propz not in (1,2)))
		)					 
					 ) b ON a.cd_emp = b.cd_emp
													     AND a.cd_campanha_adic = b.cd_campanha_adic
			INNER JOIN (SELECT a.cd_emp, a.cd_prod,
							   b.cd_arv_merc_familia,
							   sum(a.qt_it) qt_it
					      FROM EST_PROD_DESCONTO_TEMP a 
							   inner join est_prod_est_arv_mercadologica b on a.cd_emp  = b.cd_emp 
																		  and a.cd_prod = b.cd_prod
   					     WHERE a.cd_emp = in_cd_emp 
						   and a.cd_filial = in_cd_filial 
						   and a.cd_ctr_vd = in_cd_vd  
						 group by a.cd_emp, a.cd_prod,
							     b.cd_arv_merc_familia 	) c ON a.cd_emp = c.cd_emp
														   AND a.cd_arv_merc_familia = c.cd_arv_merc_familia;


	INSERT INTO RsCampanhaPossivelAquisicao
	SELECT 
		d.tp_campanha,
		a.cd_emp,
		a.cd_prod,
		max(b.cd_campanha_adic),		 
		cast(sum(a.qt_it) as integer) qt_it_posivel_brinde ,	
		cast(sum(a.qt_it) as integer) qt_it_posivel_brinde ,	
		a.vlr_item - a.vlr_item_liq as desconto, 
		a.vlr_item,
		
		--round(a.vlr_it * (1-(a.tx_desc/100)), 2),
		b.vlr_venda
	FROM   
		EST_PROD_DESCONTO_TEMP a 
		inner join pdv_campanha_adicionais_est_prod b on
			a.cd_emp = b.cd_emp and
			a.cd_prod=b.cd_prod 
		inner join pdv_campanha_adicionais c on
			b.cd_emp = c.cd_emp and
			b.cd_campanha_adic = c.cd_campanha_adic 
			
		INNER JOIN RsCampanha d on
			c.cd_emp = d.cd_emp and
			c.cd_campanha_adic = d.cd_campanha_adic  
	WHERE  
		a.cd_emp = in_cd_emp 
		and a.cd_filial = in_cd_filial 
		and a.cd_ctr_vd = in_cd_vd  
		and DATE(dt_inicio) <= CURRENT_DATE	AND DATE(dt_valid) >= CURRENT_DATE
	GROUP  BY 
		a.cd_prod,a.cd_emp,b.cd_campanha_adic, b.vlr_venda, a.vlr_item, b.qt_venda, a.vlr_item_liq,d.tp_campanha
	ORDER BY a.cd_prod asc;

     delete from RsCampanhaPossivelAquisicao 
	 where 
		cd_campanha_adic in ( select min(cd_campanha_adic) 
								from RsCampanhaPossivelAquisicao 
								where cd_prod in (select cd_prod 								
														from RsCampanhaPossivelAquisicao 
														group by cd_prod having count(1) > 1
													));
												


ELSE
	-------------------------------------------------------------------
	-- INSERINDO PROD CAMPANHA
	
	INSERT INTO RsCampanhaProduto
	SELECT a.cd_emp,
		   a.cd_campanha_adic,
		   a.cd_prod,
		   a.qtde_prod,
           sum(coalesce(c.qt_it,0)) as saldo
	FROM   pdv_campanha_adicionais_est_prod_campanha a
		  INNER JOIN (SELECT a.*
					    FROM pdv_campanha_adicionais a
					         join pdv_campanha_adicionais_prc_filial fil on a.cd_campanha_adic = fil.cd_campanha_adic
							                                            and a.cd_emp = fil.cd_emp 							 
					   WHERE fil.cd_filial = in_cd_filial 
					     and DATE(a.dt_inicio)  <= CURRENT_DATE
						 AND DATE(a.dt_valid )  >= CURRENT_DATE
						AND	(
							((in_usa_desconto_propz_ident = 1) AND (A.flag_tp_desconto_propz in(0,1)) ) OR 
							((in_usa_desconto_propz_ident = 0) AND (A.flag_tp_desconto_propz not in (1,2)))
							)		 
						) b ON a.cd_emp = b.cd_emp
						AND a.cd_campanha_adic = b.cd_campanha_adic
		   LEFT JOIN (SELECT a.cd_emp,
							 a.cd_prod,
							 Sum(a.qt_it) qt_it
					  FROM   pdv_vd_it a
					  WHERE  a.cd_emp = in_cd_emp 
						and a.cd_filial = in_cd_filial 
						and a.cd_vd  = in_cd_vd 
						and flag_direto_caixa = 1
						AND a.st_it = 1
					  GROUP  BY a.cd_prod, a.cd_emp) c ON a.cd_emp = c.cd_emp
													  AND a.cd_prod = c.cd_prod
	GROUP  BY a.cd_emp,a.cd_campanha_adic,a.cd_prod,a.qtde_prod;


	insert into RsCampanha
	select cd_emp, cd_campanha_adic, 0 from RsCampanhaProduto group by cd_emp, cd_campanha_adic;
	
	-------------------------------------------------------------------------
	
	-- INSERINDO FAMILIA CAMPANHA
	INSERT INTO RsCampanhaFamilia
	select
		   a.cd_emp,
		   a.cd_campanha_adic,  
		   a.cd_arv_merc_familia,
		   a.qtde_prod,
		   sum(coalesce(c.qt_it,0)) as saldo
	from
	  pdv_campanha_adicionais_est_arv_merc_familia_campanha a
	  INNER JOIN (SELECT a.*
					FROM pdv_campanha_adicionais a
					     join pdv_campanha_adicionais_prc_filial fil on a.cd_campanha_adic = fil.cd_campanha_adic
							                                        and a.cd_emp = fil.cd_emp 							 
			       WHERE fil.cd_filial = in_cd_filial 
						and DATE(a.dt_inicio )<= CURRENT_DATE
						AND DATE(a.dt_valid  )>= CURRENT_DATE
						AND	(
							((in_usa_desconto_propz_ident = 1) AND (A.flag_tp_desconto_propz in(0,1)) ) OR 
							((in_usa_desconto_propz_ident = 0) AND (A.flag_tp_desconto_propz not in (1,2)))
							)
					 					  
						) b ON a.cd_emp = b.cd_emp
						AND a.cd_campanha_adic = b.cd_campanha_adic
					
           LEFT JOIN (SELECT a.cd_emp,
						     b.cd_arv_merc_familia ,
							 Sum(a.qt_it) qt_it
					    FROM pdv_vd_it a
        					 inner join est_prod_est_arv_mercadologica b  on a.cd_emp = b.cd_emp 
																		 and a.cd_prod = b.cd_prod
 					   WHERE a.cd_emp    = in_cd_emp 
					     and a.cd_filial = in_cd_filial 
						 and a.cd_vd     = in_cd_vd 
						 and flag_direto_caixa = 1
   						 AND a.st_it      = 1
					   GROUP  BY a.cd_emp,
							     b.cd_arv_merc_familia) c ON a.cd_emp = c.cd_emp
														 AND a.cd_arv_merc_familia = c.cd_arv_merc_familia
	group by
		a.cd_emp,
		a.cd_campanha_adic,
		a.cd_arv_merc_familia,
		a.qtde_prod ;

 
	insert into RsCampanha
	select cd_emp, cd_campanha_adic, 1 from RsCampanhaFamilia  group by cd_emp, cd_campanha_adic;


	INSERT INTO RsCampanhaProdutoFamilia
	select
		   a.cd_emp,
		   a.cd_campanha_adic,
		   a.cd_arv_merc_familia,
		   c.cd_prod,
		   COALESCE (c.qt_it,0)
	from
	  pdv_campanha_adicionais_est_arv_merc_familia_campanha a
	  INNER JOIN (SELECT a.*
					FROM pdv_campanha_adicionais a
					     join pdv_campanha_adicionais_prc_filial fil on a.cd_campanha_adic = fil.cd_campanha_adic
							                                        and a.cd_emp = fil.cd_emp 							 
				   WHERE fil.cd_filial = in_cd_filial 
					 and DATE(a.dt_inicio)   <= CURRENT_DATE
					 AND DATE(a.dt_valid )   >= CURRENT_DATE
		AND	(
			((in_usa_desconto_propz_ident = 1) AND (A.flag_tp_desconto_propz in(0,1)) ) OR 
			((in_usa_desconto_propz_ident = 0) AND (A.flag_tp_desconto_propz not in (1,2)))
		)					 
					 ) b ON a.cd_emp = b.cd_emp
													     AND a.cd_campanha_adic = b.cd_campanha_adic
			INNER JOIN (SELECT a.cd_emp, a.cd_prod,
							   b.cd_arv_merc_familia,
							   sum(a.qt_it) qt_it
					      FROM pdv_vd_it a 
							   inner join est_prod_est_arv_mercadologica b on a.cd_emp  = b.cd_emp 
																		  and a.cd_prod = b.cd_prod
   					     WHERE a.cd_emp = in_cd_emp 
						   and a.cd_filial = in_cd_filial 
						   and a.cd_vd = in_cd_vd 
						   and flag_direto_caixa = 1
   						   AND a.st_it = 1
						 group by a.cd_emp, a.cd_prod,
							     b.cd_arv_merc_familia 	) c ON a.cd_emp = c.cd_emp
														   AND a.cd_arv_merc_familia = c.cd_arv_merc_familia;

	--Produtos brinde
	INSERT INTO RsCampanhaPossivelAquisicao
	SELECT 
		d.tp_campanha,
		a.cd_emp,
		a.cd_prod,
		max(b.cd_campanha_adic),		 
		cast(sum(a.qt_it) as integer) qt_it_posivel_brinde ,	
		cast(sum(a.qt_it) as integer) qt_it_posivel_brinde ,	
		round(a.vlr_it * (1-(a.tx_desc/100)), 2) - b.vlr_venda as desconto, 
		a.vlr_it,
		
		--round(a.vlr_it * (1-(a.tx_desc/100)), 2),
		b.vlr_venda
	FROM   
		pdv_vd_it a 
		inner join pdv_campanha_adicionais_est_prod b on
			a.cd_emp = b.cd_emp and
			a.cd_prod=b.cd_prod 
		inner join pdv_campanha_adicionais c on
			b.cd_emp = c.cd_emp and
			b.cd_campanha_adic = c.cd_campanha_adic 
			
		INNER JOIN RsCampanha d on
			c.cd_emp = d.cd_emp and
			c.cd_campanha_adic = d.cd_campanha_adic  
	WHERE  
		a.cd_emp = in_cd_emp 
		and a.cd_filial = in_cd_filial 
		and a.cd_vd = in_cd_vd 
		and flag_direto_caixa = 1
		AND a.st_it = 1 
		and DATE(dt_inicio) <= CURRENT_DATE	AND DATE(dt_valid) >= CURRENT_DATE
	GROUP  BY 
		a.cd_prod,a.cd_emp,b.cd_campanha_adic, b.vlr_venda, a.vlr_it, b.qt_venda, a.tx_desc,d.tp_campanha
	ORDER BY a.cd_prod asc;

     delete from RsCampanhaPossivelAquisicao 
	 where 
		cd_campanha_adic in ( select min(cd_campanha_adic) 
								from RsCampanhaPossivelAquisicao 
								where cd_prod in (select cd_prod 								
														from RsCampanhaPossivelAquisicao 
														group by cd_prod having count(1) > 1
													));
	
	
 END IF;
-------------------------------------------------------------------------
-- FIM COLETA DE DADOS
-------------------------------------------------------------------------


	-- removendo campanhas que nao concederam brindes
	delete from RsCampanhaProduto where saldo < 1;
    DELETE 
		   FROM RSCAMPANHAFAMILIA A 
		  WHERE A.SALDO < 1 
		    AND NOT EXISTS ( SELECT B.CD_CAMPANHA_ADIC 
		                       FROM RSCAMPANHAFAMILIA B 
						      WHERE B.CD_EMP           = A.CD_EMP 
						        AND B.CD_CAMPANHA_ADIC = A.CD_CAMPANHA_ADIC 
								AND B.saldo >0
                              group by B.CD_CAMPANHA_ADIC  );


	-- removendo brindes vinculado a campanhas que nao concederam brindes
	delete from RsCampanhaPossivelAquisicao a
         where not exists(select g.cd_campanha_adic from RsCampanhaProduto g where g.cd_campanha_adic = a.cd_campanha_adic union
                          select g.cd_campanha_adic from RsCampanhaFamilia g where g.cd_campanha_adic = a.cd_campanha_adic );
	delete from RsCampanhaProdutoFamilia a where not exists(select g.cd_campanha_adic from RsCampanhaFamilia g where g.cd_campanha_adic = a.cd_campanha_adic );

    RAISE NOTICE '=======================================================================';
	RAISE NOTICE 'TRATAR CAMPANHA POR PRODUTO LINHA 903';


	--VERIFICANDO SE
	IF EXISTS (select a.cd_emp
		        from RsCampanhaPossivelAquisicao a
				where 
					a.qt_it_posivel_brinde > 0 
					and a.tp_campanha = 0)
	THEN

		WHILE TRUE LOOP

			--DELETE FROM RsCampanhaProduto WHERE saldo < 1;
			--RAISE NOTICE 'Removeu produtos sem saldo';

			IF EXISTS(SELECT cd_emp FROM RsCampanhaProduto)
			THEN
			
				RAISE NOTICE 'Encontrado produto brinde para tratamento';
				
				IF EXISTS(SELECT cd_emp FROM RsCampanhaProduto WHERE saldo / qtde_prod > 0)
				THEN

					RAISE NOTICE 'Existe campanha apta a concesao de brinde';
					-- CAPTURANDO PRIMEIRO PRODUTO POSSIVEL BRINDE
					SELECT a.* INTO rProdBrinde 
					FROM 
						RsCampanhaPossivelAquisicao a 
					where 
						a.qt_it_posivel_brinde > 0 
						and a.tp_campanha = 0  LIMIT 1;
					
					RAISE NOTICE 'Brinde a ser tratado % ', rProdBrinde;

					IF EXISTS ( select a.cd_emp 
									from 
										RsCampanhaPossivelAquisicao a 
										left join RsCampanhaProduto b on 
										a.cd_emp 			= b.cd_emp and 
										a.cd_campanha_adic 	= b.cd_campanha_adic and 
										a.cd_prod 			= b.cd_prod
									where 
										a.cd_emp = rProdBrinde.cd_emp 
										and a.cd_campanha_adic = rProdBrinde.cd_campanha_adic 
										and a.cd_prod = rProdBrinde.cd_prod
										and b.cd_campanha_adic is null 
										
										)THEN

						RAISE NOTICE 'Produto brinde nao faz parte dos produto que devem ser adiquiridos %', rProdBrinde.cd_prod;

						insert into RetornoTemp values(rProdBrinde.cd_prod, rProdBrinde.cd_campanha_adic, '', 
														rProdBrinde.desconto, 1, rProdBrinde.vlr_item, rProdBrinde.vlr_venda ,1 );

						var_vlr_desconto = var_vlr_desconto + rProdBrinde.desconto;

						RAISE NOTICE 'Desconto de % pelo produto % ', rProdBrinde.desconto, rProdBrinde.cd_prod;

						UPDATE RsCampanhaProduto 
						SET 
							saldo = saldo - qtde_prod,
							utilizado = utilizado + qtde_prod
						 WHERE  
							cd_emp = rProdBrinde.cd_emp 
							and cd_campanha_adic = rProdBrinde.cd_campanha_adic;

						UPDATE 
							RsCampanhaPossivelAquisicao 
						SET 
							qt_it_posivel_brinde = qt_it_posivel_brinde - 1
						WHERE  
								cd_emp = rProdBrinde.cd_emp
							and cd_campanha_adic = rProdBrinde.cd_campanha_adic
							AND cd_prod = rProdBrinde.cd_prod;

						RAISE NOTICE 'Removeu a quantidade de uma unidade dos produtos brindes e baixou o saldo nessario para concesao';

					ELSE
					
						IF EXISTS(
									select a.cd_emp from RsCampanhaPossivelAquisicao a 
									INNER join RsCampanhaProduto b on 
										a.cd_emp = b.cd_emp and 
										a.cd_campanha_adic = b.cd_campanha_adic and 
										a.cd_prod = b.cd_prod
									where 
										a.cd_emp = rProdBrinde.cd_emp 
										and a.cd_campanha_adic = rProdBrinde.cd_campanha_adic 
										and a.cd_prod = rProdBrinde.cd_prod
										   ) THEN

							RAISE NOTICE 'Produto brinde faz parte dos produto que devem ser adiquiridos';
							
							RAISE NOTICE '-------- % ', rProdBrinde.cd_prod;
							UPDATE RsCampanhaProduto 
							SET saldo = saldo - 1
							WHERE  
								cd_emp = rProdBrinde.cd_emp 
								and cd_campanha_adic = rProdBrinde.cd_campanha_adic;


							RAISE NOTICE 'Removeu a quantidade de uma unidade dos produtos que sao brinde e aquisicao e do saldo para concesao';

							IF EXISTS(SELECT cd_emp FROM RsCampanhaProduto
											WHERE 
												cd_emp = rProdBrinde.cd_emp 
												and cd_campanha_adic = rProdBrinde.cd_campanha_adic 
												AND saldo / qtde_prod > 0)
							THEN
								RAISE NOTICE 'Existe campanha apta a concesao de brinde';
								
								insert into RetornoTemp 
								values(rProdBrinde.cd_prod, rProdBrinde.cd_campanha_adic, '', rProdBrinde.desconto, 1, 
											rProdBrinde.vlr_item, rProdBrinde.vlr_venda, 1 );
											
								var_vlr_desconto = var_vlr_desconto + rProdBrinde.desconto;
								
								RAISE NOTICE 'Desconto de % pelo produto % campanha % ', rProdBrinde.desconto, rProdBrinde.cd_prod, rProdBrinde.cd_campanha_adic;

								UPDATE RsCampanhaProduto 
								SET saldo = saldo - qtde_prod,
									utilizado = utilizado + qtde_prod
								WHERE  
									cd_emp = rProdBrinde.cd_emp 
									and cd_campanha_adic = rProdBrinde.cd_campanha_adic;
								
								UPDATE RsCampanhaPossivelAquisicao as Aq
								SET qt_it_posivel_brinde = aq.qt_it_posivel_brinde - pr.qtde_prod
								FROM
									RsCampanhaProduto pr 
								WHERE  
									pr.cd_emp 			=  aq.cd_emp and 
									pr.cd_campanha_adic =  aq.cd_campanha_adic and 
									
										aq.cd_emp = rProdBrinde.cd_emp 
									and aq.cd_campanha_adic = rProdBrinde.cd_campanha_adic 
									AND aq.cd_prod = rProdBrinde.cd_prod;
																		
								
								RAISE NOTICE 'Removeu a quantidade de uma unidade dos produtos brindes e baixou o saldo nessario para concesao';
							ELSE
								RAISE NOTICE 'APOS REMOVER O PRODUTO BRINDE DA LISTA DE PREMIOS CLIENTE FICOU SEM DIREITO';
								EXIT; -- APOS REMOVER O PRODUTO BRINDA DA LISTA DE PREMIOS CLIENTE FICOU SEM DIREITO
							END IF;
						ELSE
							RAISE NOTICE 'GRAVE POIS FUNCAO CHEGOU AQUI COM A INFORMACAO QUE EXISTE PRODUTO BRINDE';
							EXIT; -- nao tem binde
						END IF;
					END IF;
				ELSE
					RAISE NOTICE 'SAINDO DO LOOP POIS NAO TEVE DIREITO A BRINDE';
					EXIT; --- SAI DO LOOP SE NAO TIVER DIREITO
				END IF;
			ELSE
				RAISE NOTICE 'NAO ENCONTRADO NENHUMA CAMPANHA';
				EXIT; -- nao tem binde
			END IF;

		END LOOP;

	END IF;


	RAISE NOTICE '';
	RAISE NOTICE '=======================================================================';
	RAISE NOTICE 'TRATAR CAMPANHA POR FAMILIA';

	--select * into retTemp from RsCampanhaPossivelAquisicao;
	--RAISE NOTICE 'TESTESTES';
	--RAISE NOTICE 'TE%TE',retTemp;

	--VERIFICANDO SE
	IF EXISTS (select a.cd_emp from RsCampanhaPossivelAquisicao a  where a.qt_it_posivel_brinde > 0 and a.tp_campanha = 1)
	THEN

		RAISE NOTICE 'Encontrado produto brinde para tratamento';
 
 		  DELETE 
		   FROM RSCAMPANHAFAMILIA A 
		  WHERE A.SALDO < 1 
		    AND NOT EXISTS ( SELECT B.CD_CAMPANHA_ADIC 
		                       FROM RSCAMPANHAFAMILIA B 
						      WHERE B.CD_EMP           = A.CD_EMP 
						        AND B.CD_CAMPANHA_ADIC = A.CD_CAMPANHA_ADIC 
								AND B.saldo >0
                              group by B.CD_CAMPANHA_ADIC  );
 
		WHILE TRUE LOOP


			SELECT * INTO rec_familia FROM RsCampanhaFamilia WHERE saldo / qtde_prod < 1;

			DELETE FROM RsCampanhaFamilia WHERE cd_campanha_adic = rec_familia.cd_campanha_adic;
			DELETE FROM RsCampanhaPossivelAquisicao WHERE cd_campanha_adic = rec_familia.cd_campanha_adic;

			IF EXISTS(SELECT cd_emp FROM RsCampanhaFamilia)
			THEN

				IF  EXISTS(SELECT cd_emp FROM RsCampanhaFamilia WHERE saldo / qtde_prod >0)
				THEN

					RAISE NOTICE 'Existe campanha apta a concesao de brinde';

					-- CAPTURANDO PRIMEIRO PRODUTO POSSIVEL BRINDE
					SELECT a.* INTO rProdBrinde FROM RsCampanhaPossivelAquisicao a where a.tp_campanha = 1 LIMIT 1;

					IF coalesce(rProdBrinde.cd_emp,0) <> 0
					THEN

						RAISE NOTICE 'Brinde a ser tratado % ', rProdBrinde;

						FOR rec_familia IN SELECT * FROM RsCampanhaFamilia WHERE  cd_emp = rProdBrinde.cd_emp and cd_campanha_adic = rProdBrinde.cd_campanha_adic
						LOOP
							RAISE NOTICE 'PRODUTOS DA FAMIL % ', rec_familia;
						END LOOP;

						IF EXISTS (
							select a.cd_emp from RsCampanhaPossivelAquisicao a left join
												 RsCampanhaProdutoFamilia b on a.cd_emp = b.cd_emp and a.cd_campanha_adic = b.cd_campanha_adic and a.cd_prod = b.cd_prod
										   where a.cd_emp = rProdBrinde.cd_emp and a.cd_campanha_adic = rProdBrinde.cd_campanha_adic and a.cd_prod = rProdBrinde.cd_prod
												 and b.cd_campanha_adic is null and a.qt_it_posivel_brinde > 0
						)THEN



							RAISE NOTICE 'SEM VINCULO COMPRA - Produto brinde nao faz parte dos produto que devem ser adiquiridos';

							IF NOT EXISTS(SELECT cd_emp FROM RsCampanhaFamilia
										WHERE cd_emp = rProdBrinde.cd_emp and cd_campanha_adic = rProdBrinde.cd_campanha_adic AND saldo / qtde_prod < 1)
							THEN
								insert into RetornoTemp values(rProdBrinde.cd_prod, rProdBrinde.cd_campanha_adic, '', rProdBrinde.desconto, 1, rProdBrinde.vlr_item, rProdBrinde.vlr_venda, 1 );
								var_vlr_desconto = var_vlr_desconto + rProdBrinde.desconto;

								RAISE NOTICE 'SEM VINCULO COMPRA - Desconto de % pelo produto % ', rProdBrinde.desconto, rProdBrinde.cd_prod;


								--UPDATE RsCampanhaFamilia SET saldo = saldo - qtde_prod
								--  WHERE  cd_emp = rProdBrinde.cd_emp and cd_campanha_adic = rProdBrinde.cd_campanha_adic;

								   UPDATE RsCampanhaFamilia AS v
								   SET saldo = saldo - v.qtde_prod
								   FROM RsCampanhaProdutoFamilia AS s
								   WHERE v.cd_emp = s.cd_emp and v.cd_emp = rProdBrinde.cd_emp
									  and v.cd_arv_merc_familia = s.cd_arv_merc_familia
								   and s.cd_campanha_adic = rProdBrinde.cd_campanha_adic;

								UPDATE RsCampanhaPossivelAquisicao SET qt_it_posivel_brinde = qt_it_posivel_brinde - 1
								  WHERE  cd_emp = rProdBrinde.cd_emp
																	--and cd_campanha_adic = rProdBrinde.cd_campanha_adic
																	AND cd_prod = rProdBrinde.cd_prod;

								RAISE NOTICE 'SEM VINCULO COMPRA - Removeu a quantidade de uma unidade dos produtos brindes e baixou o saldo nessario para concesao';

							ELSE
								UPDATE RsCampanhaPossivelAquisicao SET qt_it_posivel_brinde = qt_it_posivel_brinde - 1
								  WHERE  cd_emp = rProdBrinde.cd_emp
																	 --and cd_campanha_adic = rProdBrinde.cd_campanha_adic
																		 AND cd_prod = rProdBrinde.cd_prod;

								RAISE NOTICE 'SEM VINCULO COMPRA - Removeu a quantidade de uma unidade dos produtos brindes e baixou o saldo nessario para concesao';

							END IF;


						ELSE


							IF EXISTS(
								select a.cd_emp from RsCampanhaPossivelAquisicao a INNER join
												 RsCampanhaProdutoFamilia b on a.cd_emp = b.cd_emp and a.cd_campanha_adic = b.cd_campanha_adic and a.cd_prod = b.cd_prod
										   where a.cd_emp = rProdBrinde.cd_emp and a.cd_campanha_adic = rProdBrinde.cd_campanha_adic
											and a.cd_prod = rProdBrinde.cd_prod and a.qt_it_posivel_brinde > 0
							)THEN

								RAISE NOTICE 'COM VINCULO COMPRA - Produto brinde faz parte dos produto que devem ser adiquiridos';

								UPDATE RsCampanhaProdutoFamilia SET qtde_prod = qtde_prod - 1
								  WHERE  cd_emp = rProdBrinde.cd_emp
									--and cd_campanha_adic = rProdBrinde.cd_campanha_adic
								  AND cd_prod = rProdBrinde.cd_prod;

								--UPDATE RsCampanhaFamilia SET saldo = saldo - 1
								--  WHERE  cd_emp = rProdBrinde.cd_emp and cd_campanha_adic = rProdBrinde.cd_campanha_adic;

															   UPDATE RsCampanhaFamilia AS v
								   SET saldo = saldo - 1
								   FROM RsCampanhaProdutoFamilia AS s
								   WHERE v.cd_emp = s.cd_emp and v.cd_emp = rProdBrinde.cd_emp
									  and v.cd_arv_merc_familia = s.cd_arv_merc_familia
								   and s.cd_campanha_adic = rProdBrinde.cd_campanha_adic;


								RAISE NOTICE 'COM VINCULO COMPRA - Removeu a quantidade de uma unidade dos produtos que sao brinde e aquisicao e do saldo para concesao';

								IF NOT EXISTS(SELECT cd_emp FROM RsCampanhaFamilia
									WHERE cd_emp = rProdBrinde.cd_emp and cd_campanha_adic = rProdBrinde.cd_campanha_adic AND saldo / qtde_prod < 1)
								THEN

									RAISE NOTICE 'COM VINCULO COMPRA - Existe campanha apta a concesao de brinde';
									insert into RetornoTemp values(rProdBrinde.cd_prod, rProdBrinde.cd_campanha_adic, '', rProdBrinde.desconto, 1, rProdBrinde.vlr_item , rProdBrinde.vlr_venda,1);
									var_vlr_desconto = var_vlr_desconto + rProdBrinde.desconto;
									RAISE NOTICE 'COM VINCULO COMPRA - Desconto de % pelo produto % ', rProdBrinde.desconto, rProdBrinde.cd_prod;

									--UPDATE RsCampanhaFamilia SET saldo = saldo - qtde_prod
									--  WHERE  cd_emp = rProdBrinde.cd_emp and cd_campanha_adic = rProdBrinde.cd_campanha_adic;

									UPDATE RsCampanhaFamilia AS v
									SET saldo = saldo - v.qtde_prod
									FROM RsCampanhaProdutoFamilia AS s
									WHERE v.cd_emp = s.cd_emp and v.cd_emp = rProdBrinde.cd_emp
																		 and v.cd_arv_merc_familia = s.cd_arv_merc_familia
																	and s.cd_campanha_adic = rProdBrinde.cd_campanha_adic;

									UPDATE RsCampanhaPossivelAquisicao SET qt_it_posivel_brinde = qt_it_posivel_brinde - 1
									  WHERE  cd_emp = rProdBrinde.cd_emp
																		   --and cd_campanha_adic = rProdBrinde.cd_campanha_adic
										AND cd_prod = rProdBrinde.cd_prod;

									RAISE NOTICE 'COM VINCULO COMPRA - Removeu a quantidade de uma unidade dos produtos brindes e baixou o saldo nessario para concesao';

								END IF;

							ELSE
								DELETE FROM  RsCampanhaPossivelAquisicao
								WHERE cd_campanha_adic = rProdBrinde.cd_campanha_adic and cd_prod =rProdBrinde.cd_prod;

								IF NOT EXISTS(SELECT cd_emp FROM RsCampanhaPossivelAquisicao where tp_campanha = 1 LIMIT 1)
								THEN
									EXIT; -- nao tem binde
								END IF;
							END IF;

						END IF;
					ELSE


						RAISE NOTICE 'SAINDO DO LOOP POIS NAO TEVE DIREITO A BRINDE';
						EXIT; --- SAI DO LOOP SE NAO TIVER DIREITO

					END IF;
				ELSE
					RAISE NOTICE 'NAO EXISTEMM MAIS BRINDES';
					EXIT; -- nao tem binde
				END IF;

			ELSE
				RAISE NOTICE 'NAO ENCONTRADO NENHUMA CAMPANHA';
				EXIT; -- nao tem binde

			END IF;

		END LOOP;
	END IF;

	RAISE NOTICE '=============================FIM==========================================';
	RAISE NOTICE 'valor total de desconto %', var_vlr_desconto;

	insert into RetornoTemp(cd_prod, cd_campanha_adic, ds_campanha_adic, vlr_desconto, qt_it,vlr_item, vlr_venda, brinde)
	SELECT 
		cd_prod, 
		cd_campanha_adic, 
		'' as ds_campanha_adic, 
		utilizado* desconto, 
		utilizado, 
		utilizado* vlr_item, 
		utilizado* vlr_venda, 
		0 brinde
	FROM 
		RsCampanhaProduto ;
		
	
	UPDATE RetornoTemp AS v
	SET 
		ds_campanha_adic = s.ds_campanha_adic
	FROM 
		pdv_campanha_adicionais AS s
	WHERE 
		v.cd_campanha_adic = s.cd_campanha_adic; 
		
	FOR rRetorno IN
		SELECT 
			t.cd_prod, 
			t.cd_campanha_adic, 
			t.ds_campanha_adic, 
			sum(t.qt_it) 		qt_it, 			
			sum(t.vlr_item)- sum(t.vlr_venda) vlr_desconto, 
			sum(t.vlr_item)	vlr_item, 
			sum(t.vlr_venda)	vlr_desconto, 			
			0 AS 			AGREGACAO,
			sum (p.deduzir) qt_util,
			t.brinde
		FROM 
			RetornoTemp as t
			left join RsCampanhaPossivelAquisicao p on 
			t.cd_prod = p.cd_prod and
			t.cd_campanha_adic = p.cd_campanha_adic  			
		group by t.cd_prod, t.cd_campanha_adic, t.ds_campanha_adic,t.brinde
	LOOP
		RETURN NEXT rRetorno;
	END LOOP;
	
END;
$function$
;
